package editor;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.BufferedReader;

import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

public class RoomListItem extends JPanel {
	
	
	private JLabel startCheckEndLabel;
	
	private JLabel nameLabel;
	
	private String name;
	
	private RoomEditorPanel panel;
	
	private static ImageIcon blankIcon = new ImageIcon(RoomListItem.class.getResource("/images/room_icon_blank.GIF"));
	private static ImageIcon startIcon = new ImageIcon(RoomListItem.class.getResource("/images/room_icon_start.GIF"));
	private static ImageIcon checkIcon = new ImageIcon(RoomListItem.class.getResource("/images/room_icon_check.GIF"));
	private static ImageIcon goalIcon = new ImageIcon(RoomListItem.class.getResource("/images/room_icon_goal.GIF"));
	private static ImageIcon startCheckIcon = new ImageIcon(RoomListItem.class.getResource("/images/room_icon_start_check.GIF"));
	private static ImageIcon startGoalIcon = new ImageIcon(RoomListItem.class.getResource("/images/room_icon_start_goal.GIF"));
	private static ImageIcon checkGoalIcon = new ImageIcon(RoomListItem.class.getResource("/images/room_icon_check_goal.GIF"));
	private static ImageIcon allIcon = new ImageIcon(RoomListItem.class.getResource("/images/room_icon_all.GIF"));
	
	
	private static final Color deadEndBgColor = new Color(200, 50, 0);
	private static final Color deadEndBorderColor = new Color(150, 0, 0);
	
	private static final Color okayStartBgColor = new Color(0, 150, 0);
	private static final Color okayStartBorderColor = new Color(0, 100, 0);
	
	private static final Color okayGoalBgColor = new Color(0, 100, 255);
	private static final Color okayGoalBorderColor = new Color(0, 50, 200);
	
	private static final Color unenterableBgColor = new Color(255, 200, 0);
	private static final Color unenterableBorderColor = new Color(255, 100, 0);
	
	private static final Color connectedBgColor = new Color(200, 255, 200);
	private static final Color connectedBorderColor = new Color(150, 200, 150);
	
	private static final Color noConnectionBgColor = new Color(125, 125, 125);
	private static final Color noConnectionBorderColor = new Color(75, 75, 75);
	
	
	public RoomListItem(NewRoomSetupWizard wizard, MainEditorPanel theMainPanel) {
		
		panel = new RoomEditorPanel(theMainPanel, wizard, this);
		
		nameLabel = new JLabel("   " + wizard.getRoomName());
		name = wizard.getRoomName();
		
		this.setLayout(new GridBagLayout());
		
		GridBagConstraints c = new GridBagConstraints();
		
//		c.weightx = 0.5;
//		c.gridx = 0;
//		c.gridy = 0;
//		c.gridwidth = 1;
//		c.insets = new Insets(0, 0, 10, 0);
//		c.anchor = GridBagConstraints.LINE_START;
//		this.add(new JPanel(), c);
		
		c.weightx = 0.5;
		c.gridx = 0;
		c.gridy = 0;
		c.gridwidth = 1;
		c.insets = new Insets(0, 0, 10, 0);
		c.anchor = GridBagConstraints.LINE_START;
		
		startCheckEndLabel = new JLabel(new ImageIcon(RoomListItem.class.getResource("/images/room_icon_blank.GIF")));
		
		this.add(startCheckEndLabel, c);
		
		c.gridx = 1;
		c.gridwidth = 4;
		
		
		this.add(nameLabel, c);
		
		JButton summaryButton = new JButton("...");
		Dimension summaryButtonSize = new Dimension(20, 20);
		summaryButton.setPreferredSize(summaryButtonSize);
		summaryButton.setPreferredSize(summaryButtonSize);
		summaryButton.setPreferredSize(summaryButtonSize);
		summaryButton.setSize(summaryButtonSize);
		c.weightx = 0.0;
		c.gridx = 5;
		c.gridwidth = 1;
		c.insets = new Insets(0, 0, 0, 10);
		c.anchor = GridBagConstraints.LINE_END;
		summaryButton.addActionListener(new ActionListener() {
			@Override
			public void actionPerformed(ActionEvent arg0) {
				showRoomSummary();
			}
		});
		this.add(summaryButton, c);
		
		
		c.insets = new Insets(0, 0, 0, 0);
		c.gridx = 6;
		c.anchor = GridBagConstraints.LINE_END;
		JButton editButton = new JButton("Edit...");
		editButton.addActionListener(new ActionListener() {
			
			@Override
			public void actionPerformed(ActionEvent arg0) {
				openEditorPanel();
			}
		});
		this.add(editButton, c);
		
		
		this.setBackground(new Color(255, 200, 0));
		
		this.setBorder(BorderFactory.createLineBorder(new Color(255, 100, 0)));
		
		Dimension d = new Dimension(325, 75);
		this.setSize(d);
		this.setPreferredSize(d);
		this.setMinimumSize(d);
		this.setMaximumSize(d);
		
		this.updateIconAndColor();
		
	}
	
	
	

	public RoomListItem(BufferedReader in, MainEditorPanel theMainPanel) throws Exception {
		
		panel = new RoomEditorPanel(in, theMainPanel, this);
		
		nameLabel = new JLabel("   " + name);
		
		this.setLayout(new GridBagLayout());
		
		GridBagConstraints c = new GridBagConstraints();
		
//		c.weightx = 0.5;
//		c.gridx = 0;
//		c.gridy = 0;
//		c.gridwidth = 1;
//		c.insets = new Insets(0, 0, 10, 0);
//		c.anchor = GridBagConstraints.LINE_START;
//		this.add(new JPanel(), c);
		
		c.weightx = 0.5;
		c.gridx = 0;
		c.gridy = 0;
		c.gridwidth = 1;
		c.insets = new Insets(0, 0, 10, 0);
		c.anchor = GridBagConstraints.LINE_START;
		
		
		startCheckEndLabel = new JLabel(new ImageIcon(RoomListItem.class.getResource("/images/room_icon_blank.GIF")));
		
		this.add(startCheckEndLabel, c);

		c.gridx = 1;
		c.gridwidth = 4;
		
		
		this.add(nameLabel, c);
		
		JButton summaryButton = new JButton("...");
		Dimension summaryButtonSize = new Dimension(20, 20);
		summaryButton.setPreferredSize(summaryButtonSize);
		summaryButton.setPreferredSize(summaryButtonSize);
		summaryButton.setPreferredSize(summaryButtonSize);
		summaryButton.setSize(summaryButtonSize);
		c.weightx = 0.0;
		c.gridx = 5;
		c.gridwidth = 1;
		c.insets = new Insets(0, 0, 0, 10);
		c.anchor = GridBagConstraints.LINE_END;
		summaryButton.addActionListener(new ActionListener() {
			@Override
			public void actionPerformed(ActionEvent arg0) {
				showRoomSummary();
			}
		});
		this.add(summaryButton, c);
		
		
		c.insets = new Insets(0, 0, 0, 0);
		c.gridx = 6;
		c.anchor = GridBagConstraints.LINE_END;
		JButton editButton = new JButton("Edit...");
		editButton.addActionListener(new ActionListener() {
			
			@Override
			public void actionPerformed(ActionEvent arg0) {
				openEditorPanel();
			}
		});
		this.add(editButton, c);
		
		
		this.setBackground(new Color(255, 200, 0));
		
		this.setBorder(BorderFactory.createLineBorder(new Color(255, 100, 0)));
		
		Dimension d = new Dimension(325, 75);
		this.setSize(d);
		this.setPreferredSize(d);
		this.setMinimumSize(d);
		this.setMaximumSize(d);
		
//		System.out.println("got to the end of the RoomListItem load method!");
		
		this.updateIconAndColor();
	}
	
	
	public void setName(String newName) {
		nameLabel.setText("   " + newName);
		name = newName;
	}
	
		
	public RoomEditorPanel getPanel() {
		return panel;
	}
	
	
	public void openEditorPanel() {
		
		
		if(panel.getFrame() != null) {
			JOptionPane.showMessageDialog(null, "There is already a window open for this room.","Already one open",JOptionPane.WARNING_MESSAGE);
			return;
		}
		
		
		JFrame theFrame = new JFrame();
		
		theFrame.setContentPane(panel);
		panel.setFrame(theFrame);
		theFrame.setTitle(name);
		
//		theFrame.addKeyListener(new KeyAdapter() {
//			@Override
//			public void keyPressed(KeyEvent e) {
//				System.out.println("it was in the frame!");
//			}
//		});
		
		theFrame.setSize(new Dimension(707, 550));
		
		theFrame.setVisible(true);
		
	}
	
	public void showRoomSummary() {
		
		String summary = panel.retrieveSummary();
		
		JOptionPane.showMessageDialog(null, summary, "Room Summary", JOptionPane.INFORMATION_MESSAGE);
		
	}
	
	public String getName() {
		return name;
	}
	
	public void updateIconAndColor() {
		
		if(panel.isStartRoom()) {
			if(panel.containsCheckpoint()) {
				if(panel.containsGoal()) {
					startCheckEndLabel.setIcon(allIcon);
				} else {
					startCheckEndLabel.setIcon(startCheckIcon);
				}
			} else {
				if(panel.containsGoal()) {
					startCheckEndLabel.setIcon(startGoalIcon);
				} else {
					startCheckEndLabel.setIcon(startIcon);
				}
			}
		} else {
			if(panel.containsCheckpoint()) {
				if(panel.containsGoal()) {
					startCheckEndLabel.setIcon(checkGoalIcon);
				} else {
					startCheckEndLabel.setIcon(checkIcon);
				}
			} else {
				if(panel.containsGoal()) {
					startCheckEndLabel.setIcon(goalIcon);
				} else {
					startCheckEndLabel.setIcon(blankIcon);
				}
			}
		}
		
		
		/*if(panel.isStartRoom()) {
			
			if(panel.containsOutgoingDoor()) {
				this.setBackground(okayStartBgColor);
				this.setBorder(BorderFactory.createLineBorder(okayStartBorderColor));
			} else {
				this.setBackground(deadEndBgColor);
				this.setBorder(BorderFactory.createLineBorder(deadEndBorderColor));
			}
			
		} else if(panel.containsGoal()) {
			
			if(panel.containsIncomingDoor()) {
				
				this.setBackground(okayGoalBgColor);
				this.setBorder(BorderFactory.createLineBorder(okayGoalBorderColor));
				
			} else if
 			
		}*/
		
		boolean startCanOverrideColor = true;
		boolean goalCanOverrideColor = true;
		
		Color newBgColor = null;
		Color newBorderColor = null;
		
		if(panel.containsIncomingDoor()) {
			
			if(panel.containsOutgoingDoor()) {
				newBgColor = connectedBgColor;
				newBorderColor = connectedBorderColor;
			} else {
				startCanOverrideColor = false;
				
				newBgColor = deadEndBgColor;
				newBorderColor = deadEndBorderColor;
			}
			
		} else {
			
			if(panel.containsOutgoingDoor()) {
				goalCanOverrideColor = false;
				
				newBgColor = unenterableBgColor;
				newBorderColor = unenterableBorderColor;
			} else {
				
				startCanOverrideColor = false;
				goalCanOverrideColor = false;
				
				newBgColor = noConnectionBgColor;
				newBorderColor = noConnectionBorderColor;
				
			}
			
		}
		
		
		
		if(panel.isStartRoom() && startCanOverrideColor && panel.containsStartPoint()) {
			newBgColor = okayStartBgColor;
			newBorderColor = okayStartBorderColor;
		}
		
		if(panel.containsGoal() && goalCanOverrideColor) {
			newBgColor = okayGoalBgColor;
			newBorderColor = okayGoalBorderColor;
		}
		
		
		this.setBackground(newBgColor);
		this.setBorder(BorderFactory.createLineBorder(newBorderColor));
		
		
		
		
	}
	
}
